/*
 * CarControl.cpp
 */
#include <Servo.h>
#include "arduino.h"
#include "CarControl.h"

// --- 初期化 ----------------------------------------------------------------

CarControl::CarControl(){
//	Serial.begin(9600); //Open the serial port and set the baud rate to 9600
//	Serial.println("CarControl()");
	_speed = 3;
}

void CarControl::initEye(){
//	Serial.println("initEye()");
	_servo.attach(3);
	_servo.write(90);
	delay(500);
	_servo.write(0);
	delay(500);
	_servo.write(180);
	delay(500);
	_servo.write(90);
	delay(500);
}

void CarControl::init(){
//	Serial.println("init()");
	pinMode(IN1,  OUTPUT);
	pinMode(IN2,  OUTPUT);
	pinMode(IN3,  OUTPUT);
	pinMode(IN4,  OUTPUT);
	pinMode(ENA,  OUTPUT);
	pinMode(ENB,  OUTPUT);	
	pinMode(ECHO, INPUT);
	pinMode(TRIG, OUTPUT);
	initEye();
}

// --- 超音波センサー関連 ----------------------------------------------------

int CarControl::getDistance() {
	digitalWrite(TRIG, LOW);   
	delayMicroseconds(2);
	digitalWrite(TRIG, HIGH);  
	delayMicroseconds(20);
	digitalWrite(TRIG, LOW);   
	float Fdistance = pulseIn(ECHO, HIGH);  
	Fdistance = Fdistance / 58;       
	return (int)Fdistance;
}

// --- Servo 関連 ------------------------------------------------------------

void CarControl::setEye(int angle){
	if (angle < 0)
		angle = 0;
	if (angle > 180)
		angle = 180;
	_servo.write(angle);
}

// --- ライントラッキングセンサー関連 ----------------------------------------

bool CarControl::LisBlack(){
	return !digitalRead(LineTrackingL);	
}

bool CarControl::CisBlack(){
	return !digitalRead(LineTrackingC);	
}

bool CarControl::RisBlack(){
	return !digitalRead(LineTrackingR);	
}

// --- 車輪制御関連 ----------------------------------------------------------

void CarControl::disableMotor(){
	digitalWrite(ENA, LOW);
	digitalWrite(ENB, LOW);
}

void CarControl::enableMotor(){
	if (_speed == 3){
		digitalWrite(ENA,HIGH);
		digitalWrite(ENB,HIGH);
	} else if (_speed == 1){
		analogWrite(ENA, 120);
		analogWrite(ENB, 120);
	} else if (_speed == 2){
		analogWrite(ENA, 180);
		analogWrite(ENB, 180);
	}
}

void CarControl::setSpeed(int speed){
	if ((speed >= 1) && (speed <= 3)){
		_speed = speed;
	}
}

void CarControl::forward(unsigned long ms){
	disableMotor();
	digitalWrite(IN1,HIGH);
	digitalWrite(IN2,LOW);
	digitalWrite(IN3,LOW);
	digitalWrite(IN4,HIGH);
	enableMotor();
	delay(ms);
}

void CarControl::back(unsigned long ms)
{
	disableMotor();
	digitalWrite(IN1,LOW);
	digitalWrite(IN2,HIGH);
	digitalWrite(IN3,HIGH);
	digitalWrite(IN4,LOW);
	enableMotor();
	delay(ms);
}

void CarControl::rotateR(unsigned long ms){
	disableMotor();
	digitalWrite(IN1,HIGH);
	digitalWrite(IN2,LOW);
	digitalWrite(IN3,HIGH);
	digitalWrite(IN4,LOW);
	enableMotor();
	delay(ms);	
}

void CarControl::rotateL(unsigned long ms)
{
	disableMotor();
	digitalWrite(IN1,LOW);
	digitalWrite(IN2,HIGH);
	digitalWrite(IN3,LOW);
	digitalWrite(IN4,HIGH);
	enableMotor();
	delay(ms);	
}

void CarControl::turnR(unsigned long ms){
	disableMotor();
	digitalWrite(IN1,HIGH);
	digitalWrite(IN2,LOW);
	digitalWrite(IN3,LOW);      
	digitalWrite(IN4,LOW);
	enableMotor();
	delay(ms);	
}

void CarControl::turnL(unsigned long ms)
{
	disableMotor();
	digitalWrite(IN1,LOW);
	digitalWrite(IN2,LOW);
	digitalWrite(IN3,LOW);
	digitalWrite(IN4,HIGH);
	enableMotor();
	delay(ms);	
}

void CarControl::turnLB(unsigned long ms){
	disableMotor();
	digitalWrite(IN1,LOW);
	digitalWrite(IN2,HIGH);
	digitalWrite(IN3,LOW);      
	digitalWrite(IN4,LOW);
	enableMotor();
	delay(ms);	
}

void CarControl::turnRB(unsigned long ms)
{
	disableMotor();
	digitalWrite(IN1,LOW);
	digitalWrite(IN2,LOW);
	digitalWrite(IN3,HIGH);
	digitalWrite(IN4,LOW);
	enableMotor();
	delay(ms);	
}

void CarControl::brake(unsigned long ms)
{
	disableMotor();
	digitalWrite(IN1,LOW);      
	digitalWrite(IN2,LOW);
	digitalWrite(IN3,LOW);      
	digitalWrite(IN4,LOW);
	enableMotor();
	delay(ms);
}

void CarControl::pause(unsigned long ms){
	disableMotor();
	digitalWrite(IN1,LOW);      
	digitalWrite(IN2,LOW);
	digitalWrite(IN3,LOW);      
	digitalWrite(IN4,LOW);
	delay(ms);
}

