/*
 * Car.h
 */
#ifndef __CAR_CONTROL_H__
#define __CAR_CONTROL_H__

#include <Servo.h>
#include "arduino.h"

// ENA, IN1, IN2 : 左車輪
// ENB, IN3, IN4 : 右車輪
// ENA, ENB : Speed / PWM
#define IN1		(7)
#define IN2		(8)
#define IN3		(9)
#define IN4		(11)
#define	ENA		(5)
#define	ENB		(6)
#define SERVO	(3)
#define ECHO	(A4)
#define TRIG	(A5)

#define LineTrackingR (10)
#define LineTrackingC (4)
#define LineTrackingL (2)

class CarControl
{
	public:
		CarControl();
		void init();                   // 初期化

		// --- 車輪制御関連 -----------------------------------------------------
		void forward(unsigned long ms);// 前進
		void back(unsigned long ms);   // 後進
		void rotateL(unsigned long ms);// 左回転
		void rotateR(unsigned long ms);// 右回転
		void turnL(unsigned long ms);  // 左ターン（右車輪前進）
		void turnR(unsigned long ms);  // 右ターン（左車輪前進）
		void turnRB(unsigned long ms); // 右ターン（右車輪後退）
		void turnLB(unsigned long ms); // 左ターン（左車輪後退）
		void brake(unsigned long ms);  // ブレーキ
		void pause(unsigned long ms);  // 一時停止
		void setSpeed(int speed);      // 速度設定（1:低速 2:中速 3:高速）

		// --- ライントラッキングセンサー関連 -----------------------------------
		bool LisBlack();               // 左センサー黒検知
		bool CisBlack();               // 中央センサー黒検知
		bool RisBlack();               // 右センサー黒検知

		// --- Servo 関連 -------------------------------------------------------
		void setEye(int angle);        // 超音波センサーの角度(0-180  右方向=0)

		// --- 超音波センサー関連 -----------------------------------------------
		int  getDistance();            // 壁までの距離を返す [cm]

	private:
		int	 	_speed;
		Servo	_servo;
		
		void disableMotor();           // モータ停止
		void enableMotor();            // モータ開始
		void initEye();                // 超音波センサー初期化
};

#endif // __CAR_CONTROL_H__

